
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Script to the programming exercise 4.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Example for the representation of the triangulation 
Elements=[1 2 6 
          2 3 4
          3 4 6
          4 5 6
          1 6 5];
Nodes=[0  0
        1  0
        1  1
        0  1
        0  .5
        .5 .5];
Boundary=[1; 2; 3; 4; 5];
    
 % Plot the triangulation
figure
u=zeros(length(Nodes),1);
trisurf(Elements,Nodes(:,1),Nodes(:,2),u)
view([0 0 1])
axis('equal')

% corresponding mass and stiffness matrix
M=[ 0.0625    0.0208         0         0    0.0104    0.0312
    0.0208    0.1250    0.0417    0.0417         0    0.0208
         0    0.0417    0.1250    0.0625         0    0.0208
         0    0.0417    0.0625    0.1458    0.0104    0.0312
    0.0104         0         0    0.0104    0.0417    0.0208
    0.0312    0.0208    0.0208    0.0312    0.0208    0.1250];
A=[ 1.0000         0         0         0   -0.5000   -0.5000
         0    1.0000   -0.5000         0         0   -0.5000
         0   -0.5000    1.5000   -0.5000         0   -0.5000
         0         0   -0.5000    1.5000   -0.5000   -0.5000
   -0.5000         0         0   -0.5000    2.0000   -1.0000
   -0.5000   -0.5000   -0.5000   -0.5000   -1.0000    3.0000];
 
%% Handling of txt-files
% load the j-te grid 
j=2;
Nodes=load(['Nodes_',num2str(j),'.txt']);
Elements=load(['Elements_',num2str(j),'.txt']);
Boundary=load(['Boundary_',num2str(j),'.txt']);

% plot
figure
u=zeros(length(Nodes),1);
trisurf(Elements,Nodes(:,1),Nodes(:,2),u)
view([0 0 1])
axis('equal')
