###########################################################################
# Script to the programming exercise 4.
###########################################################################

## Example for the representation of the triangulation
Elements = [1 2 6
            2 3 4
            3 4 6
            4 5 6
            1 6 5]

Nodes = [0.0  0.0
         1.0  0.0
         1.0  1.0
         0.0  1.0
         0.0  0.5
         0.5  0.5]

Boundary = [1; 2; 3; 4; 5]

# Plot the triangulation
using Plots
u = zeros(size(Nodes, 1))
plot(Nodes[:, 1], Nodes[:, 2],
     seriestype=:scatter,
     aspect_ratio=:equal,
     legend=false)

# Draw the triangles
for i in 1:size(Elements, 1)
    tri_indices = Elements[i, :]
    tri_x = [Nodes[tri_indices, 1]; Nodes[tri_indices[1], 1]]
    tri_y = [Nodes[tri_indices, 2]; Nodes[tri_indices[1], 2]]
    plot!(tri_x, tri_y, color=:black, linewidth=1)
end
display(current())

# Corresponding mass and stiffness matrix
M = [0.0625  0.0208       0.0       0.0  0.0104  0.0312
     0.0208  0.1250  0.0417  0.0417       0.0  0.0208
          0  0.0417  0.1250  0.0625       0.0  0.0208
          0  0.0417  0.0625  0.1458  0.0104  0.0312
     0.0104       0       0.0  0.0104  0.0417  0.0208
     0.0312  0.0208  0.0208  0.0312  0.0208  0.1250]

A = [ 1.0 0.0 0.0 0.0 -0.5 -0.5
      0.0 1.0 -0.5 0.0 0.0 -0.5
      0.0 -0.5 1.5 -0.5 0.0 -0.5
      0.0 0.0 -0.5 1.5 -0.5 -0.5
     -0.5 0.0 0.0 -0.5 2.0 -1.0
     -0.5 -0.5 -0.5 -0.5 -1.0 3.0]

## Handling of txt-files
using DelimitedFiles

# Load the j-th grid
j = 2
Nodes = readdlm("Nodes_$j.txt")
Elements = Int.(readdlm("Elements_$j.txt"))
Boundary = Int.(readdlm("Boundary_$j.txt"))

# Plot
u = zeros(size(Nodes, 1))
plot(Nodes[:, 1], Nodes[:, 2],
     seriestype=:scatter,
     aspect_ratio=:equal,
     legend=false)

# Draw the triangles
for i in 1:size(Elements, 1)
    tri_indices = Elements[i, :]
    tri_x = [Nodes[tri_indices, 1]; Nodes[tri_indices[1], 1]]
    tri_y = [Nodes[tri_indices, 2]; Nodes[tri_indices[1], 2]]
    plot!(tri_x, tri_y, color=:black, linewidth=1)
end
display(current())
